<?php
/***************************************************************************
 *                                  faq.php
 *                            -------------------
 *   begin                : Sunday, Jul 8, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *   modification         : (C) 2005 Przemo www.przemo.org/phpBB2/
 *   date modification    : ver. 1.9 2005/10/24 13:36
 *
 *   $Id: faq.php,v 1.14.2.2 2004/07/11 16:46:15 acydburn Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
define('ATTACH', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_FAQ);
init_userprefs($userdata);
//
// End session management
//

if ( $board_config['login_require'] && !$userdata['session_logged_in'] )
{
	$message = $lang['login_require'] . '<br /><br />' . sprintf($lang['login_require_register'], '<a href="' . append_sid("profile.$phpEx?mode=register") . '">', '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

// Set vars to prevent naughtiness
$faq = array();

function faq_sl_decode($value)
{
	$value = str_replace(':_sl_;', '\\', $value);
	$value = str_replace(':_qu_;', '"', $value);
	$value = str_replace(".'$'.", "$", $value);

	return $value;
}

// Load the appropriate faq file
$mode = get_vars('mode', '', 'GET');
switch( $mode )
{
    case 'bbcode':
        $lang_file = 'lang_bbcode';
        $l_title   = $lang['BBCode_guide'];
        break;
    default:
        $lang_file = 'lang_faq';
        $l_title   = $lang['FAQ'];
        break;
}
include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/' . $lang_file . '.' . $phpEx);

if ( defined('ATTACHMENTS_ON') && $mode != 'bbcode' )
{
	if (!file_exists($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_faq_attach.'.$phpEx))
	{
		include($phpbb_root_path . 'language/lang_english/lang_faq_attach.'.$phpEx);
	}
	else
	{
		include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_faq_attach.' . $phpEx);
	} 
}

//
// Pull the array data from the lang pack
//
$j = 0;
$counter = 0;
$counter_2 = 0;
$faq_block = array();
$faq_block_titles = array();

for($i = 0; $i < count($faq); $i++)
{
	if( $faq[$i][0] != '--' )
	{
		$faq_block[$j][$counter]['id'] = $counter_2;
		$faq_block[$j][$counter]['question'] = faq_sl_decode($faq[$i][0]);
		$faq_block[$j][$counter]['answer'] = faq_sl_decode($faq[$i][1]);

		$counter++;
		$counter_2++;
	}
	else
	{
		$j = ( $counter != 0 ) ? $j + 1 : 0;

		$faq_block_titles[$j] = faq_sl_decode($faq[$i][1]);

		$counter = 0;
	}
}

//
// Lets build a page ...
//
$page_title = $l_title;
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'faq_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_FAQ_TITLE' => $l_title, 
	'L_BACK_TO_TOP' => $lang['Back_to_top'])
);

for($i = 0; $i < count($faq_block); $i++)
{
	if( count($faq_block[$i]) )
	{
		$template->assign_block_vars('faq_block', array(
			'BLOCK_TITLE' => faq_sl_decode($faq_block_titles[$i]))
		);
		$template->assign_block_vars('faq_block_link', array( 
			'BLOCK_TITLE' => faq_sl_decode($faq_block_titles[$i]))
		);

		for($j = 0; $j < count($faq_block[$i]); $j++)
		{
			$row_color = ( !($j % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
			$row_class = ( !($j % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

			$template->assign_block_vars('faq_block.faq_row', array(
				'ROW_COLOR' => '#' . $row_color,
				'ROW_CLASS' => $row_class,
				'FAQ_QUESTION' => faq_sl_decode($faq_block[$i][$j]['question']), 
				'FAQ_ANSWER' => faq_sl_decode($faq_block[$i][$j]['answer']), 

				'U_FAQ_ID' => $faq_block[$i][$j]['id'])
			);

			$template->assign_block_vars('faq_block_link.faq_row_link', array(
				'ROW_COLOR' => '#' . $row_color,
				'ROW_CLASS' => $row_class,
				'FAQ_LINK' => faq_sl_decode($faq_block[$i][$j]['question']), 

				'U_FAQ_LINK' => '#' . $faq_block[$i][$j]['id'])
			);
		}
	}
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>